$NOLIST
	NAME	GfxConsole

$INCLUDE (``OsIncs`WinASM~Inc~)

RAM_CGROUP GROUP    RAM_CODE

	PUBLIC	GfxCharOut, GfxLineOut

	EXTRN	CpDrawChars:NEAR
	EXTRN	GetMeWindowState:NEAR

RAM_CODE	SEGMENT	PUBLIC	'CODE'
	ASSUME	CS:RAM_CGROUP



$EJECT
$LIST
; PROCEDURE GfxCharOut (ch: BYTE; x, y: WORD);
;
; Char is placed with its top left corner at the point (xLoc, yLoc).
; No chars are interpreted.

chXLoc      EQU [BP + 10]
chYLoc      EQU [BP + 8]
;char        EQU [BP + offsetToCh]
offsetToch  EQU 12
paramBytes  EQU 6

GfxCharOut PROC FAR

	PUSH	DS
	PUSH	BP
	MOV	BP,SP
	CALL	GetMeWindowState
	MOV	DS,AX

	PUSH      DS:wsPwindowSeg         ; screen location
	PUSH      DS:wsBytesPerLine       ; window size
	PUSH      DS:wsWindowHeight       ; window height

	MOV	AX,DS:wsTheWindowTopLeftX
	ADD	AX, chXLoc
	PUSH	AX			; screen rel xLoc
	MOV	AX,DS:wsTheWindowTopLeftY
	ADD	AX, chYLoc
	PUSH	AX			; screen rel yLoc

	PUSH      SS
          MOV       AX, BP
	ADD       AX, offsetToCh                ; ch at [BP+offsetToch]
          PUSH      AX

	MOV	AX, 1			; count
	PUSH	AX			

	LES	BX,DS:wsPFontTable
	PUSH      ES			; push the font table
          PUSH      BX
          CALL      CpDrawChars		; draw the line

	POP	BP
	POP	DS
	RET	paramBytes
GfxCharOut ENDP

PURGE chXLoc
PURGE chYLoc
PURGE offsetToch
PURGE paramBytes
$NOLIST

$EJ

; PROCEDURE GfxLineOut (VAR ch: BYTES; count, xLoc, yLoc: WORD);

chXLoc EQU [BP + 10]
chYLoc EQU [BP + 8]
count  EQU [BP + 12]
pChar  EQU DWORD PTR [BP + 14]
paramBytes EQU 10

GfxLineOut PROC FAR
	PUSH	DS
	PUSH	BP
	CALL	GetMeWindowState
	MOV	DS,AX
	MOV	BP,SP

	PUSH      DS:wsPWindowSeg           ; screen location
	PUSH      DS:wsBytesPerLine         ; window info
	PUSH      DS:wsWindowHeight         ; window info

	MOV	AX,DS:wsTheWindowTopLeftX
	ADD	AX, chXLoc
	PUSH	AX			; screen rel xLoc
	MOV	AX,DS:wsTheWindowTopLeftY
	ADD	AX, chYLoc
	PUSH	AX			; screen rel yLoc

	LES	BX, pChar			; string to print
	PUSH      ES
          PUSH      BX

	MOV	AX, count			; count
	PUSH	AX			

	LES	BX,DS:wsPFontTable
	PUSH      ES			; push the font table
          PUSH      BX
          CALL      CpDrawChars		; draw the line

	POP	BP
	POP	DS
	RET	paramBytes
GfxLineOut ENDP

PURGE chXLoc
PURGE chYLoc
PURGE count
PURGE pChar
PURGE paramBytes

RAM_CODE	ENDS

END
